/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.measurepad;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import smx.tracker.apps4xxx.measurepad.FileOpenFailed;
import smx.tracker.apps4xxx.utility.XMath;
import smx.tracker.apps4xxx.utility.tools.P;
import smx.utility.ThreadComm;
import smx.utility.UnitsConversion;

public class DataThread
extends Thread {
    public static final int SEND_DATA_TO_FILE = 1;
    public static final int SEND_DATA_TO_SOCKET = 2;
    private final int NO_OP = 3;
    private final int RESET_DATA_BUFFER = 4;
    private final int RESET_OUTPUT_FILE_NAME = 5;
    private final int SET_DATA_TO_SOCKET_FLAG = 6;
    private DecimalFormat displayFormat;
    private FileOpenFailed fileOpenFailedListener;
    private boolean sendDataToSocket;
    private boolean shutDown;
    private int MAX_BUFFER_SIZE;
    private ThreadComm dataPackets;
    private String outputFileName;
    private boolean appendFlag;
    private int threadType;
    private int numberOfPtsTransmitted;
    private int numberOfPtsSkipped;
    private int numberOfFactoryBkndPtsSkipped;
    private BufferedReader xfrmReader;
    private PrintWriter fileWriter;
    private PrintWriter socketWriter;
    private Socket socket;
    private ServerSocket servSocket;
    private int port;
    private String serverName;
    private double i_x;
    private double i_y;
    private double i_z;
    private double j_x;
    private double j_y;
    private double j_z;
    private double k_x;
    private double k_y;
    private double k_z;
    private double t_x;
    private double t_y;
    private double t_z;
    private double scale;
    private double[] xfrmMatrix;
    private UnitsConversion localLinearUnits;
    private String dummyFileStr;
    private String dummySocketStrS;
    private String dummySocketStrA;
    ServerSocketThread serverSocketThread;
    XfrmMatrixListenerThread xfrmThreadListener;

    public DataThread(String string, String string2, String string3, int n, UnitsConversion unitsConversion) throws IOException {
        block2: {
            super(string);
            this.NO_OP = 3;
            this.RESET_DATA_BUFFER = 4;
            this.RESET_OUTPUT_FILE_NAME = 5;
            this.SET_DATA_TO_SOCKET_FLAG = 6;
            this.sendDataToSocket = true;
            this.shutDown = false;
            this.MAX_BUFFER_SIZE = 1000;
            this.dataPackets = new ThreadComm(this.MAX_BUFFER_SIZE);
            this.i_x = 1.0;
            this.i_y = 0.0;
            this.i_z = 0.0;
            this.j_x = 0.0;
            this.j_y = 1.0;
            this.j_z = 0.0;
            this.k_x = 0.0;
            this.k_y = 0.0;
            this.k_z = 1.0;
            this.t_x = 0.0;
            this.t_y = 0.0;
            this.t_z = 0.0;
            this.scale = 1.0;
            this.xfrmMatrix = new double[12];
            this.threadType = string2 == null ? 2 : 1;
            this.outputFileName = string2;
            this.serverName = string3;
            this.port = n;
            try {
                this.startServer();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (this.servSocket == null) break block2;
                this.servSocket.close();
                this.servSocket = null;
            }
        }
        this.localLinearUnits = unitsConversion;
        this.initializeXfrmMatrix();
        this.setDaemon(true);
        this.displayFormat = new DecimalFormat();
        this.displayFormat.setMinimumFractionDigits(this.localLinearUnits.displayDecimalPlaces());
        this.displayFormat.setMaximumFractionDigits(this.localLinearUnits.displayDecimalPlaces());
        this.displayFormat.setGroupingSize(0);
        this.start();
    }

    public void enableDataTransmissionToSocket(boolean bl) {
        Object[] objectArray = new Object[]{new Integer(6), new Boolean(bl)};
        this.sendData(objectArray);
    }

    public void flushDataBuffer() {
        Object[] objectArray = new Object[]{new Integer(4)};
        this.sendData(objectArray);
    }

    public void resetOutPutFileName(String string, boolean bl, FileOpenFailed fileOpenFailed) {
        this.outputFileName = string;
        this.appendFlag = bl;
        this.fileOpenFailedListener = fileOpenFailed;
        Object[] objectArray = new Object[]{new Integer(5)};
        this.sendData(objectArray);
    }

    public void displayData(double d, double d2, double d3, double d4, boolean bl, double d5) {
        Object[] objectArray = new Object[3];
        double[] dArray = new double[]{d, d2, d3};
        XMath.pointSphereToCart(dArray);
        DataThread dataThread = this;
        synchronized (dataThread) {
            XMath.xfrmPointFrom2to1(this.xfrmMatrix, dArray, this.scale);
        }
        Double[] doubleArray = new Double[]{new Double(dArray[0]), new Double(dArray[1]), new Double(dArray[2]), new Double(d4), new Double(d5)};
        objectArray[0] = new Integer(this.threadType);
        objectArray[1] = doubleArray;
        objectArray[2] = new Boolean(bl);
        this.sendData(objectArray);
    }

    public void doNoOp() {
        Object[] objectArray = new Object[]{new Integer(3)};
        this.sendData(objectArray);
    }

    /*
     * Loose catch block
     */
    public void run() {
        block45: {
            block42: {
                Object[] objectArray = new Object[1];
                block27: while (!this.shutDown) {
                    try {
                        Object[] objectArray2 = this.dataPackets.receive();
                        int n = (Integer)objectArray2[0];
                        boolean bl = false;
                        String string = null;
                        String string2 = null;
                        Double[] doubleArray = null;
                        if (n == this.threadType) {
                            doubleArray = (Double[])objectArray2[1];
                            bl = (Boolean)objectArray2[2];
                            if (bl) {
                                string = new String(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.localLinearUnits.convertToDisplayStr(doubleArray[0].doubleValue())))).append("@").append(this.localLinearUnits.convertToDisplayStr(doubleArray[1].doubleValue())).append("@").append(this.localLinearUnits.convertToDisplayStr(doubleArray[2].doubleValue())))));
                            } else {
                                double d = doubleArray[0];
                                double d2 = doubleArray[1];
                                double d3 = doubleArray[2];
                                P.rintln(String.valueOf(String.valueOf(new StringBuffer("X = ").append(this.xfrmMatrix[3]).append("Y = ").append(this.xfrmMatrix[7]).append(" Z = ").append(this.xfrmMatrix[11]))));
                                double[] dArray = new double[]{this.xfrmMatrix[3] - d, this.xfrmMatrix[7] - d2, this.xfrmMatrix[11] - d3};
                                double d4 = XMath.get3DPtDistance(dArray);
                                double d5 = dArray[0] / d4;
                                double d6 = dArray[1] / d4;
                                double d7 = dArray[2] / d4;
                                if (this.fileWriter != null) {
                                    string2 = new String(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.localLinearUnits.convertToDisplayStr(d)))).append(", ").append(this.localLinearUnits.convertToDisplayStr(d2)).append(", ").append(this.localLinearUnits.convertToDisplayStr(d3)).append(", ").append(doubleArray[3].toString()))));
                                }
                                if (this.sendDataToSocket) {
                                    string = new String(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.localLinearUnits.convertToDisplayStr(d)))).append("@").append(this.localLinearUnits.convertToDisplayStr(d2)).append("@").append(this.localLinearUnits.convertToDisplayStr(d3)).append(" ").append(this.displayFormat.format(d5)).append("@").append(this.displayFormat.format(d6)).append("@").append(this.displayFormat.format(d7)).append(" ").append(this.localLinearUnits.convertToDisplayStr(doubleArray[4].doubleValue())))));
                                }
                            }
                        }
                        switch (n) {
                            case 2: {
                                if (this.fileWriter != null && !bl) {
                                    this.fileWriter.println(string2);
                                    this.dummyFileStr = string2;
                                }
                                if (!this.sendDataToSocket || this.socketWriter == null) continue block27;
                                if (bl) {
                                    this.socketWriter.print("S: ".concat(String.valueOf(String.valueOf(string))));
                                    this.socketWriter.print('\u0000');
                                    this.socketWriter.flush();
                                    this.dummySocketStrS = string;
                                } else {
                                    this.socketWriter.print("A: ".concat(String.valueOf(String.valueOf(string))));
                                    this.socketWriter.print('\u0000');
                                    this.socketWriter.flush();
                                    this.dummySocketStrA = string;
                                }
                                if (bl) continue block27;
                                ++this.numberOfPtsTransmitted;
                                continue block27;
                            }
                            case 5: {
                                this.resetOutPutFileName();
                                continue block27;
                            }
                            case 6: {
                                this.sendDataToSocket = (Boolean)objectArray2[1];
                                continue block27;
                            }
                            case 4: {
                                this.resetDataBuffer();
                                continue block27;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                Object var24_18 = null;
                try {
                    if (this.fileWriter != null) {
                        this.fileWriter.close();
                        this.fileWriter = null;
                    }
                    if (this.servSocket == null) break block42;
                    Socket socket = null;
                    DataThread dataThread = this;
                    synchronized (dataThread) {
                        try {
                            socket = new Socket(InetAddress.getLocalHost(), this.port);
                            this.wait();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    this.servSocket.close();
                    this.servSocket = null;
                    System.out.println("Server socket is closed");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.dataPackets = null;
            {
                break block45;
                catch (Exception exception) {
                    block46: {
                        exception.printStackTrace();
                        Object var24_19 = null;
                        try {
                            if (this.fileWriter != null) {
                                this.fileWriter.close();
                                this.fileWriter = null;
                            }
                            if (this.servSocket == null) break block46;
                            Socket socket = null;
                            DataThread dataThread = this;
                            synchronized (dataThread) {
                                try {
                                    socket = new Socket(InetAddress.getLocalHost(), this.port);
                                    this.wait();
                                }
                                catch (Exception exception2) {
                                    exception2.printStackTrace();
                                }
                            }
                            if (socket != null) {
                                socket.close();
                            }
                            this.servSocket.close();
                            this.servSocket = null;
                            System.out.println("Server socket is closed");
                        }
                        catch (Exception exception3) {
                            exception3.printStackTrace();
                        }
                    }
                    this.dataPackets = null;
                }
            }
            catch (Throwable throwable) {
                block49: {
                    Object var24_20 = null;
                    try {
                        if (this.fileWriter != null) {
                            this.fileWriter.close();
                            this.fileWriter = null;
                        }
                        if (this.servSocket == null) break block49;
                        Socket socket = null;
                        DataThread dataThread = this;
                        synchronized (dataThread) {
                            try {
                                socket = new Socket(InetAddress.getLocalHost(), this.port);
                                this.wait();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (socket != null) {
                            socket.close();
                        }
                        this.servSocket.close();
                        this.servSocket = null;
                        System.out.println("Server socket is closed");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.dataPackets = null;
                throw throwable;
            }
        }
    }

    void shutDown() {
        this.shutDown = true;
    }

    private synchronized void notifyServerThreadIsClosed() {
        this.notifyAll();
    }

    private void resetOutPutFileName() {
        block3: {
            if (this.outputFileName == null && this.fileWriter != null) {
                this.fileWriter.close();
                this.fileWriter = null;
                return;
            }
            try {
                this.fileWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.outputFileName, this.appendFlag)), true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                if (this.fileOpenFailedListener == null) break block3;
                this.fileOpenFailedListener.failedToOpenFile();
            }
        }
    }

    private void startServer() throws IOException {
        this.servSocket = new ServerSocket(this.port);
        this.serverSocketThread = new ServerSocketThread();
    }

    private void initializeXfrmMatrix() {
        this.xfrmMatrix[0] = this.i_x;
        this.xfrmMatrix[1] = this.j_x;
        this.xfrmMatrix[2] = this.k_x;
        this.xfrmMatrix[3] = this.t_x;
        this.xfrmMatrix[4] = this.i_y;
        this.xfrmMatrix[5] = this.j_y;
        this.xfrmMatrix[6] = this.k_y;
        this.xfrmMatrix[7] = this.t_y;
        this.xfrmMatrix[8] = this.i_z;
        this.xfrmMatrix[9] = this.j_z;
        this.xfrmMatrix[10] = this.k_z;
        this.xfrmMatrix[11] = this.t_z;
    }

    private void printMatrix(double[] dArray) {
        P.rintln("Printing the matrix");
        P.rintln("matrix length = ".concat(String.valueOf(String.valueOf(dArray.length))));
        if (dArray.length < 12) {
            return;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (i % 4 == 0) {
                P.rintln("\n");
            }
            P.rint(String.valueOf(String.valueOf(dArray[i])).concat(", "));
        }
        P.rintln("\n");
    }

    private void initialiseReaderAndWriter() throws IOException {
        this.xfrmReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.socketWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream())), true);
    }

    private void uploadXfrmMatrix() throws IOException {
        int n;
        P.rintln("Uploading the matrix");
        double[] dArray = new double[]{this.xfrmMatrix[0], this.xfrmMatrix[1], this.xfrmMatrix[2], this.xfrmMatrix[3], this.xfrmMatrix[4], this.xfrmMatrix[5], this.xfrmMatrix[6], this.xfrmMatrix[7], this.xfrmMatrix[8], this.xfrmMatrix[9], this.xfrmMatrix[10], this.xfrmMatrix[11], 0.0, 0.0, 0.0, 1.0};
        P.rintln("Current Matrix is as given below");
        this.printMatrix(dArray);
        double[] dArray2 = new double[]{this.i_x, this.j_x, this.k_x, this.t_x, this.i_y, this.j_y, this.k_y, this.t_y, this.i_z, this.j_z, this.k_z, this.t_z, 0.0, 0.0, 0.0, 1.0};
        P.rintln("New Matrix is as given below");
        this.printMatrix(dArray2);
        double[] dArray3 = new double[16];
        int n2 = 0;
        for (int i = 0; i < 16; i += 4) {
            for (n = 0; n < 4; ++n) {
                dArray3[n2++] = dArray2[i] * dArray[n] + dArray2[i + 1] * dArray[n + 4] + dArray2[i + 2] * dArray[n + 8] + dArray2[i + 3] * dArray[n + 12];
            }
        }
        P.rintln("Resulting Matrix is as given below");
        this.printMatrix(dArray3);
        DataThread dataThread = this;
        synchronized (dataThread) {
            for (n = 0; n < 12; ++n) {
                this.xfrmMatrix[n] = dArray3[n];
            }
        }
        P.rintln("Stored Matrix is as given below");
        this.printMatrix(this.xfrmMatrix);
    }

    private void resetDataBuffer() {
        this.dataPackets.flush();
        P.rintln("Dummy file str = ".concat(String.valueOf(String.valueOf(this.dummyFileStr))));
        P.rintln("Dummy Socket str 'S' = ".concat(String.valueOf(String.valueOf(this.dummySocketStrS))));
        P.rintln("Dummy Socket str 'A' = ".concat(String.valueOf(String.valueOf(this.dummySocketStrA))));
        P.rintln(String.valueOf(String.valueOf(new StringBuffer("# of pts transmitted by ").append(Thread.currentThread().getName()).append(" = ").append(this.numberOfPtsTransmitted))));
        if (this.numberOfPtsSkipped > 0) {
            P.rintln(String.valueOf(String.valueOf(new StringBuffer("*************************\t******************\n# of pts skipped by ").append(Thread.currentThread().getName()).append(" = ").append(this.numberOfPtsSkipped).append("\n*************************\t******************\n"))));
            P.rintln(String.valueOf(String.valueOf(new StringBuffer("\n------------------------\t------------------\n# of background pts skipped by ").append(Thread.currentThread().getName()).append(" = ").append(this.numberOfFactoryBkndPtsSkipped).append("\n------------------------\t------------------"))));
        }
        this.numberOfPtsTransmitted = 0;
        this.numberOfPtsSkipped = 0;
        this.numberOfFactoryBkndPtsSkipped = 0;
    }

    private void sendData(Object[] objectArray) {
        if (this.dataPackets.isFull()) {
            try {
                Thread.currentThread();
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (objectArray.length == 3) {
                if (((Boolean)objectArray[2]).booleanValue()) {
                    ++this.numberOfFactoryBkndPtsSkipped;
                } else {
                    ++this.numberOfPtsSkipped;
                }
            }
            return;
        }
        try {
            this.dataPackets.send(objectArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private synchronized void closeReaderAndWriterAndSocket() {
        try {
            if (this.socketWriter != null) {
                this.socketWriter.close();
                this.socketWriter = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            if (this.xfrmReader != null) {
                this.xfrmReader.close();
                this.xfrmReader = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static {
        SEND_DATA_TO_FILE = 1;
        SEND_DATA_TO_SOCKET = 2;
    }

    class XfrmMatrixListenerThread
    extends Thread {
        public XfrmMatrixListenerThread() {
            super("Xfrm matrix");
            this.setDaemon(true);
            this.start();
        }

        public void getMatrixElements(char[] cArray) throws IOException {
            String string = new String(cArray);
            P.rintln("Data read = ".concat(String.valueOf(String.valueOf(string))));
            StringTokenizer stringTokenizer = new StringTokenizer(string, "#,(,), ,@");
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            String string2 = stringTokenizer.nextToken();
            P.rintln("i_x = ".concat(String.valueOf(String.valueOf(string2))));
            DataThread.this.i_x = Double.parseDouble(string2);
            string2 = stringTokenizer.nextToken();
            P.rintln("i_y = ".concat(String.valueOf(String.valueOf(string2))));
            DataThread.this.i_y = Double.parseDouble(string2);
            string2 = stringTokenizer.nextToken();
            P.rintln("i_z = ".concat(String.valueOf(String.valueOf(string2))));
            DataThread.this.i_z = Double.parseDouble(string2);
            string2 = stringTokenizer.nextToken();
            P.rintln("j_x = ".concat(String.valueOf(String.valueOf(string2))));
            DataThread.this.j_x = Double.parseDouble(string2);
            string2 = stringTokenizer.nextToken();
            P.rintln("j_y = ".concat(String.valueOf(String.valueOf(string2))));
            DataThread.this.j_y = Double.parseDouble(string2);
            string2 = stringTokenizer.nextToken();
            P.rintln("j_z = ".concat(String.valueOf(String.valueOf(string2))));
            DataThread.this.j_z = Double.parseDouble(string2);
            string2 = stringTokenizer.nextToken();
            P.rintln("k_x = ".concat(String.valueOf(String.valueOf(string2))));
            DataThread.this.k_x = Double.parseDouble(string2);
            string2 = stringTokenizer.nextToken();
            P.rintln("k_y = ".concat(String.valueOf(String.valueOf(string2))));
            DataThread.this.k_y = Double.parseDouble(string2);
            string2 = stringTokenizer.nextToken();
            P.rintln("k_z = ".concat(String.valueOf(String.valueOf(string2))));
            DataThread.this.k_z = Double.parseDouble(string2);
            string2 = stringTokenizer.nextToken();
            P.rintln("t_x = ".concat(String.valueOf(String.valueOf(string2))));
            DataThread.this.t_x = Double.parseDouble(string2);
            string2 = stringTokenizer.nextToken();
            P.rintln("t_y = ".concat(String.valueOf(String.valueOf(string2))));
            DataThread.this.t_y = Double.parseDouble(string2);
            string2 = stringTokenizer.nextToken();
            P.rintln("t_z = ".concat(String.valueOf(String.valueOf(string2))));
            DataThread.this.t_z = Double.parseDouble(string2);
            DataThread.this.t_x = DataThread.this.t_x / (double)1000;
            DataThread.this.t_y = DataThread.this.t_y / (double)1000;
            DataThread.this.t_z = DataThread.this.t_z / (double)1000;
            DataThread.this.uploadXfrmMatrix();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                DataThread.this.initialiseReaderAndWriter();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            boolean bl = true;
            char[] cArray = new char[256];
            try {
                try {
                    DataThread.this.xfrmReader.read(cArray);
                    while (bl) {
                        if (cArray[0] != 'T') {
                            if (DataThread.this.xfrmReader.read(cArray) == -1) {
                                P.rintln("Client connection closed. So terminating the dedicated server side socket thread...");
                                break;
                            }
                            this.getMatrixElements(cArray);
                            cArray = new char[256];
                        } else {
                            this.getMatrixElements(cArray);
                            cArray = new char[256];
                        }
                        P.rintln("Got the XFRM from Holos Client");
                    }
                    Object var5_4 = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var5_5 = null;
                    DataThread.this.closeReaderAndWriterAndSocket();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                DataThread.this.closeReaderAndWriterAndSocket();
                throw throwable;
            }
            DataThread.this.closeReaderAndWriterAndSocket();
        }
    }

    class ServerSocketThread
    extends Thread {
        public ServerSocketThread() {
            super("Server Socket Thread");
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            while (!DataThread.this.shutDown) {
                try {
                    P.rintln("Waiting for a connection with the Holos Client");
                    if (DataThread.this.servSocket == null) {
                        return;
                    }
                    DataThread.this.socket = DataThread.this.servSocket.accept();
                    if (!DataThread.this.shutDown) {
                        new XfrmMatrixListenerThread();
                        P.rintln("Got a connection with the Holos Client");
                        continue;
                    }
                    DataThread.this.socket.close();
                    P.rintln("Closed the socket with dummy connection");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            DataThread.this.notifyServerThreadIsClosed();
        }
    }
}

