/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.diagnostics;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import smx.tracker.ContinueTrigger;
import smx.tracker.DataTag;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.DataTagUnsigned8;
import smx.tracker.DistanceMode;
import smx.tracker.Filter;
import smx.tracker.InterferometerOnly;
import smx.tracker.InterferometerSetByADM;
import smx.tracker.MeasureCfg;
import smx.tracker.MirrorTargetType;
import smx.tracker.StartTrigger;
import smx.tracker.TargetType;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.diagnostics.Diagnostics;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.TrackerAppCommandThread;
import smx.tracker.apps4xxx.utility.TrackerAppException;
import smx.tracker.apps4xxx.utility.tools.P;
import smx.tracker.event.BusyListener;
import smx.tracker.event.FactoryBkndMeasureDataListener;

class DiagnosticsThread
extends TrackerAppCommandThread
implements Runnable {
    public static final int HOME = 1;
    public static final int BACKSIGHT = 2;
    public static final int STOP_TEST = 3;
    public static final int DARK_LEVEL_CALIBRATION = 4;
    public static final int NO_TARGET_QUAD_TEST = 5;
    public static final int BACK_MIRROR_INTENSITY = 6;
    public static final int TURN_LASER_ON = 7;
    public static final int TURN_LASER_OFF = 8;
    public static final int START_FACTORY_BKND_MEASUREMENT = 9;
    public static final int STOP_FACTORY_BKND_MEASUREMENT = 10;
    public static final int START_BACKSIGHT_TEST = 11;
    private final double FACTORY_BKND_DATA_LISTENER_RATE = 0.5;
    private final int DEFAULT_SAMPLE_RATE = 2000;
    private final int SAMPLE_RATE_1000 = 1000;
    private final int SAMPLE_RATE_750 = 750;
    private final int QUICK_SAMPLE_RATE = 50;
    private final int VERY_QUICK_SAMPLE_RATE = 5;
    private final double SMR_DIA_STD = 0.0381;
    private final double SMR_DIA_7_8 = 0.022225;
    private final double SMR_DIA_1_2 = 0.0127;
    double tmrUncorrectedDist = 0.0;
    private ResourceBundle res = Diagnostics.res;
    private FactoryBkndMeasureDataListener factoryBkndDataListener;
    boolean factoryBkndMeasurementInProgress = false;

    DiagnosticsThread(Tracker tracker, ThreadListener threadListener, BusyListener busyListener, ThreadListener threadListener2, JFrame jFrame) {
        super("Diagnostics", tracker, threadListener, busyListener, threadListener2, jFrame);
        this.thread = new Thread((Runnable)this, "Diagnostics Thread");
        this.thread.setDaemon(true);
    }

    public void stopAppActivities() throws TrackerException {
        this.stopFactoryBkndMeasurement();
    }

    public void run() {
        Object var2_1 = null;
        boolean bl = false;
        this.stateTag = new DataTag[2];
        this.stateTag[0] = new DataTagUnsigned32("motor_state.int_output");
        this.stateTag[1] = new DataTagUnsigned32("control_mode.int_output");
        this.responseData = new Object[3];
        this.responseData[0] = null;
        this.responseData[1] = null;
        this.responseData[2] = null;
        this.oldBlockSetting = this.trk.getBlocking();
        boolean bl2 = false;
        try {
            Object[] objectArray;
            int n;
            this.setExclusiveAccess();
            this.trk.setBlocking(true);
            this.responseData[1] = this.getStateInfo(this.stateTag);
            DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("laser.int_output"), new DataTagUnsigned16("hene_baseline_int.status")};
            Object[] objectArray2 = this.getStateInfo(dataTagArray);
            boolean bl3 = false;
            if ((Long)objectArray2[0] == (long)0) {
                bl3 = true;
            }
            if ((n = ((Integer)objectArray2[1]).intValue()) == 0 || (n & 0x20) != 0) {
                bl2 = true;
            }
            boolean bl4 = this.trk.factoryBkndMeasureInProgress();
            Object[] objectArray3 = new Object[6];
            objectArray3[0] = new Boolean(bl4);
            objectArray3[1] = new Boolean(bl3);
            objectArray3[2] = new Boolean(bl2);
            DataTag[] dataTagArray2 = new DataTag[]{new DataTagUnsigned8("air_temp_1.input_selector"), new DataTagUnsigned8("air_temp_2.input_selector"), new DataTagUnsigned8("air_temp_3.input_selector"), new DataTagUnsigned8("air_temp_4.input_selector"), new DataTagUnsigned8("air_temp_5.input_selector"), new DataTagUnsigned8("air_temp_6.input_selector"), new DataTagUnsigned8("air_temp_7.input_selector"), new DataTagUnsigned8("air_temp_8.input_selector")};
            objectArray3[3] = objectArray = this.readOneTimeData(dataTagArray2);
            objectArray3[4] = new Boolean(this.trk.admCapable());
            objectArray3[5] = this.trk.distanceMeasureMode() instanceof InterferometerSetByADM ? new Boolean(true) : new Boolean(false);
            this.responseData[2] = objectArray3;
            this.clearExclusiveAccess();
        }
        catch (TrackerException trackerException) {
            this.responseData[0] = trackerException;
        }
        try {
            this.response.send(this.responseData);
            if (this.listener != null) {
                this.listener.commandComplete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.listenForBusyEvents();
        while (!this.shutdown) {
            try {
                Object[] objectArray = this.command.receive();
                this.commandCode = (Integer)objectArray[0];
                this.responseData = new Object[3];
                this.responseData[0] = null;
                this.responseData[1] = null;
                this.responseData[2] = null;
                switch (this.commandCode) {
                    case 1: {
                        this.trk.home(this.trk.backsightOrientation());
                        break;
                    }
                    case 7: {
                        this.turnLaserOn();
                        break;
                    }
                    case 8: {
                        this.turnLaserOff();
                        break;
                    }
                    case 4: {
                        this.doDarkLevelCalibration();
                        break;
                    }
                    case 5: {
                        this.responseData[2] = this.getNoTargetQuadData((DataTag[])objectArray[1]);
                        break;
                    }
                    case 6: {
                        this.responseData[2] = this.getBackMirrorIntensity((DataTag[])objectArray[1]);
                        break;
                    }
                    case 9: {
                        this.startFactoryBkndMeasurement((Object[])objectArray[1]);
                        this.factoryBkndMeasurementInProgress = true;
                        break;
                    }
                    case 10: {
                        this.stopFactoryBkndMeasurement();
                        this.factoryBkndMeasurementInProgress = false;
                        break;
                    }
                    case 11: {
                        this.responseData[2] = this.startBacksightTest((Integer)objectArray[1]);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case -9: {
                        this.stopAppActivities();
                        this.appIsSelfClosing = (Boolean)objectArray[1];
                        break;
                    }
                    default: {
                        throw new TrackerException("Thread received unexpected command");
                    }
                }
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
            this.sendResponseToApp();
        }
        this.ignoreBusyEvents();
    }

    private DataTag[] createDataTagArrayFromObjectArray(Object[] objectArray) {
        int n = objectArray.length;
        P.rintln("Total # of tags = ".concat(String.valueOf(String.valueOf(n))));
        DataTag[] dataTagArray = new DataTag[n];
        for (int i = 0; i < n; ++i) {
            dataTagArray[i] = (DataTag)objectArray[i];
        }
        return dataTagArray;
    }

    private void startFactoryBkndMeasurement(Object[] objectArray) throws TrackerException {
        if (this.factoryBkndMeasurementInProgress) {
            return;
        }
        this.factoryBkndDataListener = (FactoryBkndMeasureDataListener)objectArray[0];
        Object[] objectArray2 = (Object[])objectArray[1];
        DataTag[] dataTagArray = this.createDataTagArrayFromObjectArray(objectArray2);
        int n = (Integer)objectArray[2];
        Filter filter = (Filter)objectArray[3];
        StartTrigger startTrigger = (StartTrigger)objectArray[4];
        ContinueTrigger continueTrigger = (ContinueTrigger)objectArray[5];
        try {
            this.trk.setFactoryBkndMeasureBlocking(true);
            this.trk.startFactoryBkndMeasure(new MeasureCfg(n, filter, startTrigger, continueTrigger), dataTagArray);
            this.trk.addFactoryBkndMeasureDataListener(this.factoryBkndDataListener);
        }
        catch (TrackerException trackerException) {
            throw new TrackerAppException(this.res.getString("Failed_to_start_factory_bknd_measurement"));
        }
        P.rintln("Submitted the factory bknd measurement command succesfully");
    }

    private void stopFactoryBkndMeasurement() throws TrackerException {
        if (!this.factoryBkndMeasurementInProgress) {
            return;
        }
        this.trk.removeFactoryBkndMeasureDataListener(this.factoryBkndDataListener);
        this.trk.stopFactoryBkndMeasure();
    }

    private double[] startBacksightTest(int n) throws TrackerException {
        DistanceMode distanceMode = this.trk.distanceMeasureMode();
        if (n == 1) {
            this.trk.changeDistanceMeasureMode((DistanceMode)new InterferometerSetByADM());
        } else if (n == 0) {
            this.trk.changeDistanceMeasureMode((DistanceMode)new InterferometerOnly());
        }
        double[] dArray = new double[7];
        try {
            double[] dArray2 = this.getOneMeasurement(2000);
            this.checkAndAbort();
            dArray[0] = dArray2[0];
            dArray[1] = dArray2[1];
            dArray[2] = dArray2[2];
            this.trk.toggleSightOrientation();
            this.checkAndAbort();
            double[] dArray3 = this.getOneMeasurement(2000);
            this.checkAndAbort();
            dArray[3] = dArray3[0];
            dArray[4] = dArray3[1];
            dArray[5] = dArray3[2];
            dArray[6] = dArray3[3];
            this.trk.toggleSightOrientation();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.trk.changeDistanceMeasureMode(distanceMode);
            throw throwable;
        }
        this.trk.changeDistanceMeasureMode(distanceMode);
        return dArray;
    }

    void doDarkLevelCalibration() throws TrackerException {
        this.trk.command("calibrate darklev", 10000);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object[] getNoTargetQuadData(DataTag[] dataTagArray) throws TrackerException {
        Object[] objectArray = null;
        double[] dArray = null;
        boolean bl = true;
        try {
            dArray = this.getOneMeasurement(2000);
        }
        catch (TrackerAppException trackerAppException) {
            bl = false;
        }
        this.checkAndAbort();
        this.trk.move(0.01746, 0.01746, 1.0, false);
        this.checkAndAbort();
        try {
            objectArray = this.readOneTimeData(dataTagArray);
            Object var7_6 = null;
            if (!bl) return objectArray;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!bl) throw throwable;
            this.trk.move(dArray[1], dArray[2], dArray[0], false);
            throw throwable;
        }
        this.trk.move(dArray[1], dArray[2], dArray[0], false);
        return objectArray;
    }

    Object[] getBackMirrorIntensity(DataTag[] dataTagArray) throws TrackerException {
        boolean bl;
        double[] dArray;
        Object[] objectArray;
        block7: {
            objectArray = null;
            dArray = null;
            bl = true;
            try {
                dArray = this.getOneMeasurement(2000);
            }
            catch (TrackerAppException trackerAppException) {
                bl = false;
            }
            this.checkAndAbort();
            TargetType targetType = null;
            boolean bl2 = false;
            targetType = this.trk.targetType();
            this.trk.changeTargetType((TargetType)new MirrorTargetType());
            this.checkAndAbort();
            bl2 = true;
            this.trk.command("moveto zero", 10000);
            this.checkAndAbort();
            this.trk.search(0.02);
            this.checkAndAbort();
            try {
                objectArray = this.readOneTimeData(dataTagArray);
                Object var8_8 = null;
                if (!bl2) break block7;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (bl2) {
                    this.trk.changeTargetType(targetType);
                }
                if (bl) {
                    this.trk.move(dArray[1], dArray[2], dArray[0], false);
                }
                throw throwable;
            }
            this.trk.changeTargetType(targetType);
        }
        if (bl) {
            this.trk.move(dArray[1], dArray[2], dArray[0], false);
        }
        return objectArray;
    }

    void turnLaserOn() throws TrackerException {
        this.trk.command("laser on", 10000);
    }

    void turnLaserOff() throws TrackerException {
        this.trk.command("laser off", 10000);
    }

    static {
        HOME = 1;
        BACKSIGHT = 2;
        STOP_TEST = 3;
        DARK_LEVEL_CALIBRATION = 4;
        NO_TARGET_QUAD_TEST = 5;
        BACK_MIRROR_INTENSITY = 6;
        TURN_LASER_ON = 7;
        TURN_LASER_OFF = 8;
        START_FACTORY_BKND_MEASUREMENT = 9;
        STOP_FACTORY_BKND_MEASUREMENT = 10;
        START_BACKSIGHT_TEST = 11;
    }
}

