/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.diagnostics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import smx.tracker.apps4xxx.diagnostics.Diagnostics;
import smx.tracker.apps4xxx.diagnostics.DiagnosticsTableColumnData;
import smx.tracker.apps4xxx.diagnostics.DiagnosticsTableModel;
import smx.tracker.apps4xxx.utility.tools.XTool;

public class DiagnosticsTableDisplay
extends JPanel {
    private final int NUM_SPACES_FOR_ONE_TAB = 8;
    ResourceBundle res;
    private BorderLayout borderLayout1 = new BorderLayout();
    private DiagnosticsTableModel tableData;
    private JTable jTable1 = new JTable(this){

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }
    };
    private JScrollPane ps = new JScrollPane();
    private DiagnosticsTableColumnData[] columns;
    private String title;
    boolean tableSelectionAllowed;
    Border border1;
    TitledBorder titledBorder1;
    private String newLineString = XTool.lineSeparator();

    public DiagnosticsTableDisplay(String string, DiagnosticsTableColumnData[] diagnosticsTableColumnDataArray, String[] stringArray, boolean bl) {
        this.res = Diagnostics.res;
        this.title = string;
        this.columns = diagnosticsTableColumnDataArray;
        this.tableSelectionAllowed = bl;
        this.tableData = new DiagnosticsTableModel(this.columns, stringArray);
        try {
            this.jbInit();
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DiagnosticsTableDisplay(String string, DiagnosticsTableColumnData[] diagnosticsTableColumnDataArray, String[] stringArray) {
        this(string, diagnosticsTableColumnDataArray, stringArray, false);
    }

    public void enableControls(boolean bl) {
        this.jTable1.setEnabled(bl);
        this.ps.setEnabled(bl);
    }

    private void jbInit() throws Exception {
        if (this.title != null) {
            this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
            this.titledBorder1 = new TitledBorder(this.border1, this.title);
            this.setBorder(this.titledBorder1);
        }
        this.setLayout(this.borderLayout1);
        this.jTable1.setAutoCreateColumnsFromModel(false);
        this.jTable1.setModel(this.tableData);
        this.jTable1.setShowGrid(false);
        for (int i = 0; i < this.columns.length; ++i) {
            ColoredTableCellRenderer coloredTableCellRenderer = new ColoredTableCellRenderer();
            coloredTableCellRenderer.setHorizontalAlignment(this.columns[i].alignment);
            TableColumn tableColumn = new TableColumn(i, this.columns[i].width, coloredTableCellRenderer, null);
            this.jTable1.addColumn(tableColumn);
        }
        JTableHeader jTableHeader = this.jTable1.getTableHeader();
        jTableHeader.setUpdateTableInRealTime(false);
        jTableHeader.setReorderingAllowed(false);
        this.setMinimumSize(new Dimension(150, 70));
        this.setPreferredSize(new Dimension(150, 70));
        this.ps.getViewport().add(this.jTable1);
        this.add((Component)this.ps, "Center");
    }

    public void updateDisplay(String[][] stringArray) {
        int n = stringArray.length;
        int n2 = stringArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.jTable1.setValueAt(stringArray[i][j], i, j + 1);
            }
        }
        this.jTable1.repaint();
    }

    public void updateTable(String[][] stringArray) {
        this.tableData.updateTableData(stringArray);
        this.jTable1.setModel(this.tableData);
        this.jTable1.revalidate();
        this.jTable1.repaint();
    }

    public String getTableData(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        if (string.equals(",")) {
            bl = true;
        }
        if ((n4 = this.jTable1.getRowCount()) == 0) {
            return null;
        }
        int n5 = this.jTable1.getColumnCount();
        StringBuffer stringBuffer = new StringBuffer(1024);
        int[] nArray = new int[this.columns.length];
        for (n3 = 0; n3 < this.columns.length; ++n3) {
            stringBuffer.append(this.columns[n3].title);
            n2 = 1;
            nArray[n3] = 1;
            if (!bl) {
                String string2 = this.jTable1.getValueAt(0, n3).toString();
                n = string2.length() - this.columns[n3].title.length();
                int n6 = string2.length() / 8 + 1;
                int n7 = this.columns[n3].title.length() / 8;
                n2 = n6 - n7;
                nArray[n3] = n6;
            }
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(string);
            }
        }
        stringBuffer.append(XTool.lineSeparator());
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                String string3 = this.jTable1.getValueAt(n3, n2).toString();
                if (string3.length() == 0 || string3.equalsIgnoreCase(" ")) {
                    for (n = 0; n < nArray[n2]; ++n) {
                        stringBuffer.append(string);
                    }
                    continue;
                }
                stringBuffer.append(string3).append(string);
            }
            stringBuffer.append(XTool.lineSeparator());
        }
        return stringBuffer.toString();
    }

    public String getTableData() {
        return this.getTableData("\t");
    }

    public boolean isDataAvailable() {
        return this.jTable1.getRowCount() > 0;
    }

    public int[] getSelectedRows() {
        return this.jTable1.getSelectedRows();
    }

    public void clearSelection() {
        this.jTable1.clearSelection();
    }

    private class ColoredTableCellRenderer
    extends DefaultTableCellRenderer {
        private ColoredTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl && DiagnosticsTableDisplay.this.tableSelectionAllowed) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else if (n % 2 == 1) {
                super.setBackground(new Color(235, 235, 235));
            } else {
                super.setBackground(jTable.getBackground());
            }
            if (DiagnosticsTableDisplay.this.res.getString("Inaccurate").equals(object) || DiagnosticsTableDisplay.this.res.getString("Error").equals(object)) {
                super.setBackground(Color.red);
            }
            this.setFont(jTable.getFont());
            this.setValue(object);
            Color color = this.getBackground();
            boolean bl3 = color != null && color.equals(jTable.getBackground()) && jTable.isOpaque();
            this.setOpaque(!bl3);
            return this;
        }
    }
}

