/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.diagnostics;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import smx.tracker.AverageFilter;
import smx.tracker.DataTag;
import smx.tracker.Filter;
import smx.tracker.IntervalTrigger;
import smx.tracker.MeasureData;
import smx.tracker.NullStartTrigger;
import smx.tracker.StartTrigger;
import smx.tracker.apps4xxx.diagnostics.Diagnostics;
import smx.tracker.apps4xxx.diagnostics.DiagnosticsTableColumnData;
import smx.tracker.apps4xxx.diagnostics.DiagnosticsTableDisplay;
import smx.tracker.apps4xxx.diagnostics.DiagnosticsThread;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.tools.XTool;
import smx.tracker.apps4xxx.utility.tools.debug.P;
import smx.tracker.event.FactoryBkndMeasureDataEvent;
import smx.tracker.event.FactoryBkndMeasureDataListener;

public abstract class DiagnosticsPanel
extends JPanel {
    ResourceBundle res = Diagnostics.res;
    final DiagnosticsTableColumnData referencePositionColumn = new DiagnosticsTableColumnData(this.res.getString("Reference_position"), 175, 2);
    final DiagnosticsTableColumnData dXColumn = new DiagnosticsTableColumnData(this.res.getString("dX"), 75, 4);
    final DiagnosticsTableColumnData dYColumn = new DiagnosticsTableColumnData(this.res.getString("dY"), 75, 4);
    final DiagnosticsTableColumnData dZColumn = new DiagnosticsTableColumnData(this.res.getString("dZ"), 75, 4);
    final DiagnosticsTableColumnData dRColumn = new DiagnosticsTableColumnData(this.res.getString("dR"), 75, 4);
    final DiagnosticsTableColumnData dTColumn = new DiagnosticsTableColumnData(this.res.getString("dT"), 75, 4);
    final DiagnosticsTableColumnData dPColumn = new DiagnosticsTableColumnData(this.res.getString("dP"), 75, 4);
    final DiagnosticsTableColumnData dateColumn = new DiagnosticsTableColumnData(this.res.getString("Date"), 75, 4);
    final DiagnosticsTableColumnData timeColumn = new DiagnosticsTableColumnData(this.res.getString("Time"), 75, 4);
    AncestorListenerImplementer ancestorListenerImplementer = new AncestorListenerImplementer();
    protected DataTag[] tagsToMeasure;
    protected int intervalRate = 250;
    private String panelTitle;
    protected DecimalFormat displayFormat;
    String dataTokenizer = ";";
    ArrayList pointList = new ArrayList(100);
    int currentPtId = 1;
    String[][] strArrayPointData;
    DiagnosticsTableDisplay resultsPanel;
    protected DiagnosticsThread diagnosticsThread;
    protected Diagnostics parentTabPane;
    protected String resultsFileName;
    protected String resultsOutputDir = ".";
    protected String newLineString = XTool.lineSeparator();
    protected boolean appendData = true;
    protected JButton ctrlClear = new JButton();
    protected JButton ctrlSave = new JButton();
    protected JButton ctrlSaveAs = new JButton();
    protected JButton ctrlHome = new JButton();
    protected Dimension oldDimension = new Dimension(0, 0);
    protected boolean fontCalculatedOnce = false;
    protected HomeCmdListener homeCmdListener = new HomeCmdListener();
    protected boolean beamBroken = false;
    protected boolean homeCmdInProgress = false;
    private FactoryBkndMeasureDataImplementer factoryBkndDataListener = new FactoryBkndMeasureDataImplementer();
    private static final int NUMBER_OF_SAMPLES = 5;
    private Filter averageFilter = new AverageFilter();
    private StartTrigger nullStartTrigger = new NullStartTrigger();
    private boolean factoryBkndMeasurementsStarted = false;

    abstract void enableControls(boolean var1);

    abstract void enableAllControls(boolean var1);

    abstract void updateDisplay(MeasureData var1);

    abstract String getFileFilters();

    abstract String getDataToSaveToFile();

    protected DiagnosticsPanel(String string) {
        this.panelTitle = string;
        this.displayFormat = new DecimalFormat();
        this.displayFormat.setMinimumFractionDigits(6);
        this.displayFormat.setMaximumFractionDigits(9);
        this.displayFormat.setGroupingSize(0);
        this.addAncestorListener(this.ancestorListenerImplementer);
    }

    void setTitle(String string) {
        this.panelTitle = string;
    }

    String getTitle() {
        return this.panelTitle;
    }

    String[][] constructStringArrayFromObjectArray(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer((String)objectArray[0], this.dataTokenizer);
        int n = stringTokenizer.countTokens();
        String[][] stringArray = new String[objectArray.length][n];
        for (int i = 0; i < objectArray.length; ++i) {
            stringTokenizer = new StringTokenizer((String)objectArray[i], this.dataTokenizer);
            for (int j = 0; j < n; ++j) {
                stringArray[i][j] = stringTokenizer.nextToken();
            }
        }
        return stringArray;
    }

    void updatePointDataInTable() {
        this.strArrayPointData = this.constructStringArrayFromObjectArray(this.pointList.toArray());
        this.resultsPanel.updateTable(this.strArrayPointData);
    }

    void updateResults(String string) {
        this.pointList.add(string);
        this.updatePointDataInTable();
        ++this.currentPtId;
    }

    void clearResults() {
        this.pointList.clear();
        this.updatePointDataInTable();
        this.currentPtId = 0;
        this.ctrlClear.setEnabled(false);
        this.ctrlSave.setEnabled(false);
        this.ctrlSaveAs.setEnabled(false);
    }

    protected void onSave(ActionEvent actionEvent) {
        if (this.resultsFileName == null) {
            this.onSaveAs(actionEvent);
            return;
        }
        XTool.saveResults(Diagnostics.parentAppFrame, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.resultsOutputDir))).append(File.separator).append(this.resultsFileName))), this.getDataToSaveToFile(), this.appendData, this.res.getString("File_open_error"), this.res.getString("File_open_error_msg"));
    }

    protected void onSaveAs(ActionEvent actionEvent) {
        String[] stringArray = XTool.openFileSaveAsChooser(Diagnostics.parentAppFrame, this.res.getString("SaveAs_"), this.res.getString("Append_to_file"), this.appendData, this.resultsFileName, this.resultsOutputDir, this.getFileFilters(), this.res.getString("Invalid_file_error"), this.res.getString("Invalid_file_error_msg"));
        if (stringArray != null) {
            this.appendData = XTool.isDataAppended();
            if (stringArray[0] != null) {
                this.resultsOutputDir = stringArray[0];
            }
            if (stringArray[1] != null) {
                this.resultsFileName = stringArray[1];
                this.onSave(null);
            }
        }
    }

    void onHome(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{new Integer(1)};
        this.homeCmdInProgress = true;
        this.parentTabPane.doThreadTransaction(objectArray, "", this.homeCmdListener);
        this.startFactoryBkndMeasurement();
    }

    protected void onFocusGained() {
        if (this.oldDimension.getHeight() != 0.0 && this.oldDimension.getWidth() != 0.0) {
            this.oldDimension.setSize(50000, 50000);
            this.fontCalculatedOnce = false;
        }
        this.startFactoryBkndMeasurement();
    }

    protected void onFocusLost() {
        this.stopFactoryBkndMeasurement();
        this.beamBroken = false;
    }

    protected final void startFactoryBkndMeasurement() {
        if (this.factoryBkndMeasurementsStarted) {
            return;
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = new Integer(9);
        Object[] objectArray2 = new Object[]{this.factoryBkndDataListener, this.tagsToMeasure, new Integer(5), this.averageFilter, this.nullStartTrigger, new IntervalTrigger((double)this.intervalRate / 1000.0)};
        objectArray[1] = objectArray2;
        Diagnostics.parentApp.doThreadTransaction(objectArray, "", null, true);
        Object[] objectArray3 = Diagnostics.parentAppCommandThread.peekResponse();
        if (objectArray3 != null && objectArray3[0] == null) {
            this.factoryBkndMeasurementsStarted = true;
        }
        Diagnostics.parentApp.enableUI(true);
        P.rintln("factory bknd STARTED");
    }

    protected final void stopFactoryBkndMeasurement() {
        if (!this.factoryBkndMeasurementsStarted) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(10), this.factoryBkndDataListener};
        Diagnostics.parentApp.doThreadTransaction(objectArray, "", null, true);
        Object[] objectArray2 = Diagnostics.parentAppCommandThread.peekResponse();
        if (objectArray2 != null && objectArray2[0] == null) {
            this.factoryBkndMeasurementsStarted = false;
        }
        P.rintln("factory bknd STOPPED");
    }

    protected void initialize() {
        this.ctrlClear.setText(this.res.getString("Clear"));
        this.ctrlClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsPanel.this.clearResults();
            }
        });
        this.ctrlSave.setText(this.res.getString("Save"));
        this.ctrlSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsPanel.this.onSave(actionEvent);
            }
        });
        this.ctrlSaveAs.setText(this.res.getString("SaveAs_"));
        this.ctrlSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsPanel.this.onSaveAs(actionEvent);
            }
        });
        this.ctrlClear.setEnabled(false);
        this.ctrlClear.setMnemonic('L');
        this.ctrlSave.setEnabled(false);
        this.ctrlSave.setMnemonic('S');
        this.ctrlSaveAs.setEnabled(false);
        this.ctrlSaveAs.setMnemonic('A');
    }

    static {
        NUMBER_OF_SAMPLES = 5;
    }

    private class AncestorListenerImplementer
    implements AncestorListener {
        private AncestorListenerImplementer() {
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            DiagnosticsPanel.this.onFocusGained();
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            DiagnosticsPanel.this.onFocusLost();
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }
    }

    private class FactoryBkndMeasureDataImplementer
    implements FactoryBkndMeasureDataListener,
    Runnable {
        private ArrayList dataList = new ArrayList(1000);

        private FactoryBkndMeasureDataImplementer() {
        }

        public void dataAvailable(FactoryBkndMeasureDataEvent factoryBkndMeasureDataEvent) {
            this.dataList.clear();
            try {
                MeasureData[] measureDataArray = Diagnostics.parentApp.getInterface().readFactoryBkndMeasureData(factoryBkndMeasureDataEvent.getNumMeasurements());
                if (measureDataArray != null) {
                    this.dataList.add(measureDataArray);
                    SwingUtilities.invokeLater(this);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void run() {
            if (this.dataList.isEmpty() || !DiagnosticsPanel.this.factoryBkndMeasurementsStarted) {
                return;
            }
            MeasureData[] measureDataArray = (MeasureData[])this.dataList.remove(0);
            for (int i = 0; i < measureDataArray.length && measureDataArray[i] != null; ++i) {
                DiagnosticsPanel.this.updateDisplay(measureDataArray[i]);
            }
        }
    }

    private class HomeCmdListener
    implements ThreadListener {
        private HomeCmdListener() {
        }

        public void commandComplete() {
            Object[] objectArray;
            if (DiagnosticsPanel.this.oldDimension.getHeight() != 0.0 && DiagnosticsPanel.this.oldDimension.getWidth() != 0.0) {
                DiagnosticsPanel.this.oldDimension.setSize(50000, 50000);
                DiagnosticsPanel.this.fontCalculatedOnce = false;
            }
            if ((objectArray = DiagnosticsPanel.this.diagnosticsThread.peekResponse()) != null && objectArray[0] == null) {
                DiagnosticsPanel.this.beamBroken = false;
            }
            DiagnosticsPanel.this.homeCmdInProgress = false;
        }
    }
}

