/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.diagnostics;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.diagnostics.DiagnosticsBacksightsPane;
import smx.tracker.apps4xxx.diagnostics.DiagnosticsLaserPane;
import smx.tracker.apps4xxx.diagnostics.DiagnosticsPanel;
import smx.tracker.apps4xxx.diagnostics.DiagnosticsThread;
import smx.tracker.apps4xxx.utility.TrackerApp4xxx;
import smx.tracker.apps4xxx.utility.TrackerExceptionString;
import smx.tracker.apps4xxx.utility.tools.P;
import smx.tracker.apps4xxx.utility.tools.XTool;

public class Diagnostics
extends TrackerApp4xxx
implements Serializable {
    String packagePath = new String("/smx/tracker/apps4xxx/diagnostics/");
    JPanel panel1 = new JPanel();
    public static final ResourceBundle res = ResourceBundle.getBundle("smx.tracker.apps4xxx.diagnostics.DiagnosticsRes", Locale.getDefault());
    DiagnosticsPanel jBacksightsPane;
    DiagnosticsPanel jLaserPane;
    DiagnosticsPanel[] panelGroup;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    int oldTabIndex = 0;
    boolean factoryBkndMeasurementStarted = false;
    boolean factoryBkndLaserMeasurementStarted = false;
    boolean bTestInProgress = false;
    private JTabbedPane diagnosticsTabPane;
    private final int MAX_PANES = 2;
    boolean admCapable;
    boolean admEnabled;
    public static Diagnostics parentApp;
    public static DiagnosticsThread parentAppCommandThread;
    public static JFrame parentAppFrame;
    private boolean trackingOn = true;
    private boolean motorsOn = false;
    private boolean motorsFailed = true;
    private boolean quickBackSights = false;
    private Component component1;
    private Component component2;
    private JButton ctrlClose = new JButton();
    boolean baseLineIntensitySet = false;
    Object[] tempSensorData;

    private void initialiseGUI() {
        try {
            this.diagnosticsTabPane = new JTabbedPane();
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Diagnostics(String string, Tracker tracker, JFrame jFrame) {
        super(string, tracker, jFrame);
        parentAppFrame = jFrame;
        parentApp = this;
        this.panelGroup = new DiagnosticsPanel[2];
        this.commandThread = new DiagnosticsThread(this.trk, this.threadCreationComplete, this.trackerAppBusyListener, this.commandThreadExitListener, jFrame);
        parentAppCommandThread = (DiagnosticsThread)this.commandThread;
        this.initialiseGUI();
        this.enableUI(false);
        this.processParam(string);
    }

    public void enableUI(boolean bl) {
        this.diagnosticsTabPane.setEnabled(bl);
        this.ctrlClose.setEnabled(bl);
    }

    protected Component getAppRootComponent() {
        Component component = null;
        for (int i = 0; component == null && i < 50; ++i) {
            component = SwingUtilities.getRoot(this.diagnosticsTabPane);
            XTool.putToSleep(Thread.currentThread(), 100);
        }
        return component;
    }

    public Tracker getInterface() {
        return this.trk;
    }

    private void jbInit() throws Exception {
        this.component1 = Box.createHorizontalStrut(8);
        this.component2 = Box.createHorizontalStrut(8);
        this.ctrlClose.setMaximumSize(new Dimension(35, 25));
        this.ctrlClose.setMinimumSize(new Dimension(35, 25));
        this.ctrlClose.setPreferredSize(new Dimension(35, 25));
        this.ctrlClose.setMargin(new Insets(2, 2, 2, 2));
        this.ctrlClose.setToolTipText(res.getString("Close_app"));
        this.ctrlClose.setMnemonic('C');
        this.ctrlClose.setText(res.getString("Close"));
        this.ctrlClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Diagnostics.this.onClose(actionEvent);
            }
        });
        this.diagnosticsTabPane.setEnabled(false);
        ((Container)((Object)this)).setLayout(this.gridBagLayout1);
        this.diagnosticsTabPane.setDoubleBuffered(true);
        ((JComponent)((Object)this)).setMaximumSize(new Dimension(5000, 4000));
        ((JComponent)((Object)this)).setMinimumSize(new Dimension(550, 450));
        ((JComponent)((Object)this)).setPreferredSize(new Dimension(550, 450));
        ((Container)((Object)this)).add(this.diagnosticsTabPane, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.8, 10, 1, new Insets(8, 8, 8, 8), 0, 0));
        ((Container)((Object)this)).add(this.component1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        ((Container)((Object)this)).add(this.ctrlClose, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        ((Container)((Object)this)).add(this.component2, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
    }

    void ok_actionPerformed(ActionEvent actionEvent) {
    }

    void cancel_actionPerformed(ActionEvent actionEvent) {
    }

    public void launchApp() {
        if (this.commandThread == null) {
            return;
        }
        Object[] objectArray = this.commandThread.receiveResponse();
        if (objectArray[0] != null && objectArray[0] instanceof TrackerException) {
            this.showFatalErrorAndCloseApp(TrackerExceptionString.getError((TrackerException)((Object)objectArray[0])));
            return;
        }
        Object[] objectArray2 = (Object[])objectArray[2];
        boolean bl = (Boolean)objectArray2[0];
        if (bl) {
            this.showFatalErrorAndCloseApp(res.getString("Factory_bknd_measurements_in_progress"));
            return;
        }
        boolean bl2 = (Boolean)objectArray2[1];
        this.baseLineIntensitySet = (Boolean)objectArray2[2];
        this.tempSensorData = (Object[])objectArray2[3];
        this.jLaserPane = new DiagnosticsLaserPane(res.getString("Laser"), bl2, this.baseLineIntensitySet);
        ((DiagnosticsLaserPane)this.jLaserPane).updateTempSensorData(this.tempSensorData);
        this.admCapable = (Boolean)objectArray2[4];
        this.admEnabled = (Boolean)objectArray2[5];
        this.jBacksightsPane = new DiagnosticsBacksightsPane(res.getString("Backsights"));
        this.jLaserPane.enableAllControls(false);
        int n = 0;
        this.panelGroup[n++] = this.jLaserPane;
        this.panelGroup[n++] = this.jBacksightsPane;
        for (int i = 0; i < this.panelGroup.length; ++i) {
            this.diagnosticsTabPane.add((Component)this.panelGroup[i], this.panelGroup[i].getTitle());
        }
        if (this.quickBackSights) {
            this.diagnosticsTabPane.setSelectedIndex(1);
        }
    }

    public void setBusy(boolean bl) {
        this.diagnosticsTabPane.setEnabled(!bl);
        int n = this.diagnosticsTabPane.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.panelGroup[n].enableControls(!bl);
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public String toString() {
        return "Operational Checks";
    }

    private void processParam(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-", true);
            while (true) {
                String string2;
                if (!(string2 = stringTokenizer.nextToken()).equals("-")) {
                    continue;
                }
                while ((string2 = stringTokenizer.nextToken()).equals("-")) {
                }
                string2 = string2.trim();
                switch (string2.charAt(0)) {
                    case 'b': {
                        break;
                    }
                    case 'a': {
                        String string3 = string2.substring(1).trim();
                        if (!string3.equalsIgnoreCase("qbc")) break;
                        this.quickBackSights = true;
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public void setBusyStateToApp(boolean bl) {
        if (this.isBusy()) {
            P.rintln(String.valueOf(String.valueOf(new StringBuffer("\n\tIGNORING setBusyStateToApp() call with flag = ").append(bl).append("\n"))));
            return;
        }
        P.rintln(String.valueOf(String.valueOf(new StringBuffer("\n\tsetBusyStateToApp() called with flag = ").append(bl).append("\n"))));
        this.diagnosticsTabPane.setEnabled(!bl);
        this.panelGroup[this.diagnosticsTabPane.getSelectedIndex()].enableAllControls(!bl);
        this.ctrlClose.setEnabled(!bl);
    }
}

