/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.closure;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import smx.tracker.AverageFilter;
import smx.tracker.ContinueTrigger;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.Filter;
import smx.tracker.InterfaceBusyException;
import smx.tracker.IntervalTrigger;
import smx.tracker.MeasureCfg;
import smx.tracker.MeasureData;
import smx.tracker.NullStartTrigger;
import smx.tracker.StartTrigger;
import smx.tracker.Tracker;
import smx.tracker.TrackerApp;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.utility.ClosureMath;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.TrackerExceptionString;
import smx.tracker.event.FactoryBkndMeasureDataEvent;
import smx.tracker.event.FactoryBkndMeasureDataListener;

public class Closure
extends TrackerApp {
    private ClosureThread closureThread = null;
    private BkndMeasureData bkndListener = new BkndMeasureData();
    private ThreadCmdComplete threadComplete = new ThreadCmdComplete();
    private ExceptionListener exceptionListener = new ExceptionListener();
    private boolean appIsStable = false;
    private boolean hasExclusiveAccess = false;
    private boolean parameterError = false;
    private long targetType = 0L;
    private long sight = 0L;
    private int distStatus = 0;
    private int distCorrectedStatus = 0;
    private int azStatus = 0;
    private double distReading = 0.0;
    private double distCorrectedReading = 0.0;
    private double distChecking = 0.0;
    private String parameter = "TMR";
    private String textString = "";
    private String pointName = "";
    private ClosureMath closureMath = null;
    private ResourceBundle res = ResourceBundle.getBundle("smx.tracker.apps4xxx.closure.ClosureBundle", Locale.getDefault());
    private final int SAMPLE_RATE = 1;
    private final double BKND_DATA_LISTENER_RATE = 0.25;
    JPanel panel1 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel4 = new JPanel();
    JButton Close = new JButton();
    JPanel jPanel5 = new JPanel();
    JTextField location = new JTextField();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JLabel leftStatusBar = new JLabel();
    JLabel rightStatusBar = new JLabel();
    Border border3;
    Border border4;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JTextField distDiff = new JTextField();
    Border border1;
    JPanel jPanel3 = new JPanel();
    JPanel jPanel6 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();

    private void updateDisplay(FactoryBkndMeasureDataEvent factoryBkndMeasureDataEvent) {
        MeasureData[] measureDataArray = null;
        try {
            measureDataArray = this.trk.readFactoryBkndMeasureData(factoryBkndMeasureDataEvent.getNumMeasurements());
            this.distReading = (Double)measureDataArray[0].getDataElement(0);
            this.distStatus = (Integer)measureDataArray[0].getDataElement(1);
            this.distCorrectedReading = (Double)measureDataArray[0].getDataElement(2);
            this.distCorrectedStatus = (Integer)measureDataArray[0].getDataElement(3);
            this.targetType = (Long)measureDataArray[0].getDataElement(4);
            this.sight = (Long)measureDataArray[0].getDataElement(5);
            this.azStatus = (Integer)measureDataArray[0].getDataElement(6);
            if (this.parameterError) {
                this.textString = "*****";
                this.rightStatusBar.setText(this.res.getString("Closure_At"));
                this.location.setText(this.textString);
                this.distDiff.setText(this.res.getString("Distance_Diff"));
                return;
            }
            if (!this.parameter.equals("TMR")) {
                this.rightStatusBar.setText(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.res.getString("Closure_At")))).append(" ").append(this.pointName))));
            } else if (this.closureMath.getTMRType() == (long)0) {
                this.rightStatusBar.setText(this.res.getString("Closure_At_3_2"));
            } else if (this.closureMath.getTMRType() == (long)1) {
                if (this.targetType != (long)2) {
                    this.rightStatusBar.setText(this.res.getString("Closure_At_3_2"));
                } else {
                    this.rightStatusBar.setText(this.res.getString("Closure_At_1_2"));
                }
            }
            if (this.parameter.equals("TMR")) {
                if (((this.distStatus | this.azStatus) & 2) != 0 || ((this.distStatus | this.azStatus) & 4) != 0) {
                    this.textString = "*****";
                } else {
                    this.distReading = this.closureMath.getClosureAgainstTMR(this.targetType, this.sight, this.distReading);
                    this.textString = this.lengthUnits.convertToDisplayStr(this.distReading);
                }
            } else if (((this.distCorrectedStatus | this.azStatus) & 2) != 0 || ((this.distCorrectedStatus | this.azStatus) & 4) != 0) {
                this.textString = "*****";
            } else {
                this.distCorrectedReading = this.closureMath.getClosureAgainstPoint(this.distChecking, this.distCorrectedReading);
                this.textString = this.lengthUnits.convertToDisplayStr(this.distCorrectedReading);
            }
            this.location.setText(this.textString);
            this.distDiff.setText(this.res.getString("Distance_Diff"));
            this.resizeFont();
        }
        catch (TrackerException trackerException) {
            TrackerExceptionString.displayErrorToUser(null, trackerException, this.res.getString("Error"), "");
        }
    }

    private void startClosureThread() {
        this.closureThread = new ClosureThread(this.threadComplete);
    }

    private boolean setExclusiveAccess() throws TrackerException {
        boolean bl = this.trk.getBlocking();
        int n = 0;
        for (n = 0; n < 10; ++n) {
            try {
                this.trk.setExclusiveAccess();
                break;
            }
            catch (InterfaceBusyException interfaceBusyException) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (n == 10) {
            this.trk.setExclusiveAccess();
        }
        this.hasExclusiveAccess = true;
        this.trk.setBlocking(true);
        return bl;
    }

    private void clearExclusiveAccess(boolean bl) throws TrackerException {
        this.trk.setBlocking(bl);
        this.trk.clearExclusiveAccess();
        this.hasExclusiveAccess = false;
    }

    public Closure(String string, Tracker tracker, JFrame jFrame) {
        super(string, tracker, jFrame);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        ((Component)((Object)this)).setLocation(dimension.width / 6, dimension.height / 8);
        try {
            this.jbInit();
            this.processParam(string);
            this.startClosureThread();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.border3 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93));
        this.border4 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93));
        this.border1 = BorderFactory.createEmptyBorder();
        this.panel1.setLayout(this.gridBagLayout4);
        ((Container)((Object)this)).setLayout(this.gridLayout1);
        this.panel1.setPreferredSize(new Dimension(545, 350));
        this.Close.setText(this.res.getString("Close"));
        this.Close.setMinimumSize(new Dimension(60, 29));
        this.Close.setPreferredSize(new Dimension(70, 29));
        this.Close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Closure.this.Close_actionPerformed(actionEvent);
            }
        });
        this.jPanel4.setLayout(this.borderLayout3);
        this.jPanel4.setPreferredSize(new Dimension(486, 25));
        this.location.setEnabled(false);
        this.location.setFont(new Font("SansSerif", 1, 69));
        this.location.setBorder(this.border1);
        this.location.setPreferredSize(new Dimension(155, 67));
        this.location.setDisabledTextColor(Color.black);
        this.location.setEditable(false);
        this.location.setHorizontalAlignment(4);
        this.location.setBackground(Color.white);
        this.jPanel5.setLayout(this.gridBagLayout2);
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.gridBagLayout1);
        this.leftStatusBar.setBorder(this.border4);
        this.leftStatusBar.setText(this.lengthUnits.displayName());
        this.rightStatusBar.setBorder(this.border3);
        this.rightStatusBar.setText(this.res.getString("Closure_At"));
        this.distDiff.setFont(new Font("SansSerif", 1, 69));
        this.distDiff.setBorder(this.border1);
        this.distDiff.setDisabledTextColor(Color.black);
        this.distDiff.setEditable(false);
        this.distDiff.setText(this.res.getString("Distance_Diff"));
        this.distDiff.setHorizontalAlignment(2);
        this.distDiff.setBackground(Color.white);
        this.jPanel3.setLayout(this.borderLayout2);
        this.jPanel6.setLayout(this.borderLayout4);
        this.jPanel3.setPreferredSize(new Dimension(90, 89));
        this.jPanel6.setPreferredSize(new Dimension(125, 67));
        ((Container)((Object)this)).add(this.panel1, null);
        this.panel1.add((Component)this.jPanel5, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 1, 0, 1), 216, 28));
        this.jPanel5.add((Component)this.jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.2, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.distDiff, "Center");
        this.jPanel5.add((Component)this.jPanel6, new GridBagConstraints(1, 0, 1, 1, 4.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel6.add((Component)this.location, "Center");
        this.panel1.add((Component)this.jPanel4, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), -86, 0));
        this.jPanel4.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.Close, "East");
        this.jPanel4.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.rightStatusBar, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 137, 0));
        this.jPanel2.add((Component)this.leftStatusBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 197, 0));
        this.jPanel4.remove(this.jPanel1);
        ((Component)((Object)this)).addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Closure.this.this_componentResized(componentEvent);
            }
        });
    }

    void Close_actionPerformed(ActionEvent actionEvent) {
        try {
            this.trk.stopApplication("Closure");
        }
        catch (TrackerException trackerException) {
            trackerException.printStackTrace();
        }
    }

    public synchronized void modifyParameters(String string) {
        super.modifyParameters(string);
        this.processParam(string);
        this.leftStatusBar.setText(this.lengthUnits.displayName());
    }

    private void processParam(String string) {
        StringTokenizer stringTokenizer = null;
        String string2 = "";
        if (string == null) {
            return;
        }
        try {
            stringTokenizer = new StringTokenizer(string, "-", true);
            while (true) {
                if (!(string2 = stringTokenizer.nextToken()).equals("-")) {
                    continue;
                }
                while ((string2 = stringTokenizer.nextToken()).equals("-")) {
                }
                if ((string2 = string2.trim()).charAt(0) == 'd') {
                    this.processTMRAndDistance(string2);
                    continue;
                }
                if (string2.charAt(0) != 'b') continue;
                this.processButton(string2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    private void processTMRAndDistance(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        stringTokenizer.nextToken();
        string = stringTokenizer.nextToken().trim();
        if (string.equals("")) {
            JOptionPane.showMessageDialog(null, this.res.getString("Invalid_Parameter"), this.res.getString("Error"), 0);
            this.parameterError = true;
            return;
        }
        if (string.toUpperCase().equals("TMR")) {
            this.parameter = "TMR";
        } else {
            try {
                this.distChecking = new Double(string);
                this.parameter = "";
                this.pointName = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken().trim() : this.res.getString("Point");
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, this.res.getString("Invalid_Parameter"), this.res.getString("Error"), 0);
                this.parameterError = true;
                return;
            }
        }
    }

    private void processButton(String string) {
        boolean bl = true;
        try {
            String string2 = string.substring(1).trim();
            int n = string.indexOf("=");
            if (n == -1) {
                return;
            }
            String string3 = string.substring(n + 1).trim();
            if (!string3.equalsIgnoreCase("on")) {
                return;
            }
            bl = true;
            if (string2.startsWith("Close") && bl) {
                this.jPanel4.setPreferredSize(new Dimension(486, 58));
                this.jPanel4.add(this.jPanel1);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void startBkndMeasurement(FactoryBkndMeasureDataListener factoryBkndMeasureDataListener) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("Dist.Output"), new DataTagUnsigned16("Dist.Status"), new DataTagDouble("Dist_Corrected.Output"), new DataTagUnsigned16("Dist_Corrected.Status"), new DataTagUnsigned32("Target.Int_Output"), new DataTagUnsigned32("FB_Sight_Mode.Int_Output"), new DataTagUnsigned16("Az.Status")};
        this.trk.setFactoryBkndMeasureBlocking(true);
        this.trk.addFactoryBkndMeasureDataListener(factoryBkndMeasureDataListener);
        this.trk.startFactoryBkndMeasure(new MeasureCfg(1, (Filter)new AverageFilter(), (StartTrigger)new NullStartTrigger(), (ContinueTrigger)new IntervalTrigger(0.25)), dataTagArray);
    }

    private void prepareData() throws TrackerException {
        this.closureMath = new ClosureMath(this.trk);
    }

    public void stop() {
        boolean bl = false;
        try {
            bl = this.setExclusiveAccess();
        }
        catch (TrackerException trackerException) {
            trackerException.printStackTrace();
        }
        try {
            this.closureThread = null;
            this.trk.removeFactoryBkndMeasureDataListener((FactoryBkndMeasureDataListener)this.bkndListener);
            this.trk.stopFactoryBkndMeasure();
        }
        catch (TrackerException trackerException) {
            trackerException.printStackTrace();
        }
        try {
            if (this.hasExclusiveAccess) {
                this.clearExclusiveAccess(bl);
            }
        }
        catch (TrackerException trackerException) {
            // empty catch block
        }
        super.stop();
    }

    private void this_componentResized(ComponentEvent componentEvent) {
        if (this.textString.equals("")) {
            return;
        }
        this.resizeFont();
    }

    private void resizeFont() {
        Font font = null;
        Font font2 = this.calculateDRFont();
        Font font3 = this.calculateLocationFont();
        if (font2 == null || font3 == null) {
            return;
        }
        int n = font3.getSize();
        int n2 = font2.getSize();
        font = n2 > n ? new Font(font3.getFontName(), font3.getStyle(), n) : new Font(font3.getFontName(), font3.getStyle(), n2);
        this.location.setFont(font);
        this.distDiff.setFont(font);
    }

    private Font calculateDRFont() {
        FontMetrics fontMetrics;
        Font font = null;
        double d = 1.0E-10;
        Font font2 = this.distDiff.getFont();
        int n = font2.getSize();
        Dimension dimension = this.distDiff.getSize();
        if ((double)dimension.width < d || (double)dimension.height < d) {
            return null;
        }
        FontMetrics fontMetrics2 = ((Component)this.distDiff).getFontMetrics(font2);
        String string = this.res.getString("Distance_Diff");
        int n2 = fontMetrics2.stringWidth(string);
        int n3 = fontMetrics2.getHeight();
        while (n3 > dimension.height || n2 > dimension.width) {
            font = new Font(font2.getFontName(), font2.getStyle(), --n);
            fontMetrics = ((Component)((Object)this)).getFontMetrics(font);
            n2 = fontMetrics.stringWidth(string);
            n3 = fontMetrics.getHeight();
        }
        while (n3 < dimension.height && n2 < dimension.width) {
            font = new Font(font2.getFontName(), font2.getStyle(), ++n);
            fontMetrics = ((Component)((Object)this)).getFontMetrics(font);
            n2 = fontMetrics.stringWidth(string);
            n3 = fontMetrics.getHeight();
        }
        font = new Font(font2.getFontName(), font2.getStyle(), n - 2);
        return font;
    }

    private Font calculateLocationFont() {
        FontMetrics fontMetrics;
        int n;
        Font font = null;
        double d = 1.0E-10;
        Font font2 = this.location.getFont();
        int n2 = font2.getSize();
        Dimension dimension = this.location.getSize();
        if ((double)dimension.width < d || (double)dimension.height < d) {
            return null;
        }
        FontMetrics fontMetrics2 = ((Component)this.location).getFontMetrics(font2);
        String string = "";
        string = this.textString.startsWith("*") ? this.textString : ((n = this.textString.indexOf("-")) == -1 ? " -".concat(String.valueOf(String.valueOf(this.textString))) : " ".concat(String.valueOf(String.valueOf(this.textString))));
        n = fontMetrics2.stringWidth(string);
        int n3 = fontMetrics2.getHeight();
        while (n3 > dimension.height || n > dimension.width) {
            font = new Font(font2.getFontName(), font2.getStyle(), --n2);
            fontMetrics = ((Component)((Object)this)).getFontMetrics(font);
            n = fontMetrics.stringWidth(string);
            n3 = fontMetrics.getHeight();
        }
        while (n3 < dimension.height && n < dimension.width) {
            font = new Font(font2.getFontName(), font2.getStyle(), ++n2);
            fontMetrics = ((Component)((Object)this)).getFontMetrics(font);
            n = fontMetrics.stringWidth(string);
            n3 = fontMetrics.getHeight();
        }
        font = new Font(font2.getFontName(), font2.getStyle(), n2 - 2);
        return font;
    }

    private synchronized void signalAppStable() {
        if (!this.appIsStable) {
            this.appIsStable = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    public synchronized void waitUntilStable() {
        try {
            while (!this.appIsStable) {
                ((Object)((Object)this)).wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class BkndMeasureData
    implements FactoryBkndMeasureDataListener,
    Runnable {
        FactoryBkndMeasureDataEvent data;

        private BkndMeasureData() {
        }

        public void dataAvailable(FactoryBkndMeasureDataEvent factoryBkndMeasureDataEvent) {
            this.data = factoryBkndMeasureDataEvent;
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Closure.this.updateDisplay(this.data);
        }
    }

    private class ClosureThread
    implements Runnable {
        private ThreadListener listener = null;

        public ClosureThread(ThreadListener threadListener) {
            Thread thread = new Thread((Runnable)this, "Closure Thread");
            thread.setDaemon(true);
            this.listener = threadListener;
            thread.start();
        }

        public void run() {
            boolean bl = false;
            try {
                bl = Closure.this.setExclusiveAccess();
            }
            catch (TrackerException trackerException) {
                trackerException.printStackTrace();
            }
            try {
                Closure.this.prepareData();
                Closure.this.startBkndMeasurement(Closure.this.bkndListener);
            }
            catch (TrackerException trackerException) {
                Closure.this.exceptionListener.setException(trackerException);
                Closure.this.exceptionListener.commandComplete();
            }
            try {
                if (Closure.this.hasExclusiveAccess) {
                    Closure.this.clearExclusiveAccess(bl);
                }
            }
            catch (TrackerException trackerException) {
                // empty catch block
            }
            if (this.listener != null) {
                this.listener.commandComplete();
            }
        }
    }

    private class ExceptionListener
    implements ThreadListener,
    Runnable {
        private TrackerException exp = null;

        private ExceptionListener() {
        }

        public void commandComplete() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            TrackerExceptionString.displayErrorToUser(Closure.this.frame, this.exp, Closure.this.res.getString("Error"), "");
        }

        public void setException(TrackerException trackerException) {
            this.exp = trackerException;
        }
    }

    private class ThreadCmdComplete
    implements ThreadListener {
        private ThreadCmdComplete() {
        }

        public void commandComplete() {
            Closure.this.signalAppStable();
        }
    }
}

