/*
 * Decompiled with CFR 0.152.
 */
package smx.ftp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import smx.ftp.FtpAbortedException;
import smx.ftp.FtpAlreadyConnectedException;
import smx.ftp.FtpBusyException;
import smx.ftp.FtpDataSocketException;
import smx.ftp.FtpException;
import smx.ftp.FtpIOException;
import smx.ftp.FtpNoResponseException;
import smx.ftp.FtpNotConnectedException;
import smx.ftp.FtpOutOfPortsException;
import smx.ftp.FtpProtocolException;
import smx.utility.LittleEndianInputStream;
import smx.utility.LittleEndianOutputStream;
import smx.utility.PortUtility;
import smx.utility.TrkServerSocket;
import smx.utility.UtilityOutOfPortsException;

public class Ftp {
    private static final int COMMAND_PORT = 21;
    public static final int OPENING_DATA_CONNECTION = 150;
    public static final int COMMAND_OK = 200;
    public static final int CONNECT_OK = 210;
    public static final int GOODBYE = 221;
    public static final int DATA_PORT_CLOSED = 226;
    public static final int USER_LOGGED_IN = 230;
    public static final int NEED_PASSWORD = 331;
    public static final int DATA_PORT_CLOSED_ABNORMALLY = 426;
    public static final int USER_NOT_LOGGED_IN = 530;
    public static final int COMMAND_FAILED = 556;
    public static final int OUT_OF_SESSIONS = 421;
    protected static final int READY_FOR_COMMAND = 0;
    protected static final int WAITING_FOR_COMMAND_RESPONSE = 1;
    protected static final int WAITING_FOR_OTHER_THREAD_TO_ABORT = 2;
    protected static final int THREAD_ABORT_COMPLETE = 3;
    private static final int WAITING_FOR_ABORT_RESPONSE = 4;
    private static final int ABORT_COMPLETE = 5;
    protected static final int COMMAND_POLL_TIMEOUT = 500;
    protected BufferedReader commandInput;
    protected BufferedWriter commandOutput;
    protected Socket commandSocket;
    protected Socket dataSocket;
    private InputStream dataRawInput;
    private OutputStream dataRawOutput;
    private BufferedReader dataTextReader;
    private PrintWriter dataTextWriter;
    private DataInput dataInput;
    private DataOutput dataOutput;
    protected int commandState = 0;
    protected boolean responseIsInterrupted = false;
    private boolean dataTransferInProgress = false;
    private boolean isLittleEndianData = false;
    private String lastCommandResponse = null;
    PrintWriter debugWriter = null;
    boolean useCustomPort = false;
    private TrkServerSocket trkServerSocket;
    PortUtility portUtility;
    int cmdPort;

    public Ftp(boolean bl) {
        this.setDataOrientation(bl);
        this.trkServerSocket = new TrkServerSocket(null);
    }

    public Ftp() {
        this(false);
    }

    public Ftp(PortUtility portUtility) {
        this(false);
        this.portUtility = portUtility;
        this.trkServerSocket = new TrkServerSocket(portUtility);
    }

    public Ftp(PrintWriter printWriter, PortUtility portUtility) {
        this(portUtility);
        this.debugWriter = printWriter;
    }

    private int getResponseNum(String string) throws FtpException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FtpProtocolException();
        }
    }

    protected int getResponse(int n) throws IOException, FtpException {
        this.logLine("in setSoTimeout: " + new Date().toString());
        this.commandSocket.setSoTimeout(n);
        this.logLine("in readLine: " + new Date().toString());
        this.lastCommandResponse = this.commandInput.readLine();
        this.logLine("ftp resp: " + this.lastCommandResponse + ": " + new Date().toString());
        if (this.lastCommandResponse == null) {
            throw new FtpDataSocketException();
        }
        return this.getResponseNum(this.lastCommandResponse);
    }

    private int getNonAbortableResponse(int n) throws FtpException {
        try {
            return this.getResponse(n);
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
    }

    /*
     * Loose catch block
     */
    private int getAbortableResponse(int n) throws FtpException {
        int n2 = 0 != n ? n : 500;
        while (true) {
            int n3 = Math.min(n2, 500);
            try {
                return this.getResponse(n3);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.responseIsInterrupted) {
                    throw new FtpAbortedException();
                }
                if (n <= 0) continue;
                n2 -= n3;
                n3 = Math.min(n2, 500);
                if (0 != n2) continue;
                throw new FtpNoResponseException();
            }
            break;
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
    }

    protected void sendCommand(String string) throws FtpException {
        try {
            this.commandOutput.write(string);
            this.commandOutput.write("\r\n");
            this.commandOutput.flush();
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new FtpNoResponseException();
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
    }

    protected void flushOldResponses() throws FtpException {
        this.lastCommandResponse = null;
        try {
            int n = this.commandSocket.getInputStream().available();
            if (n > 0) {
                this.commandInput.skip(n);
            }
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
    }

    public synchronized void setDataOrientation(boolean bl) {
        this.isLittleEndianData = bl;
    }

    public String getLastResponse() throws FtpException {
        if (null == this.lastCommandResponse) {
            throw new FtpNoResponseException();
        }
        return this.lastCommandResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandOnly(String string) throws FtpException {
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.commandSocket) {
                throw new FtpNotConnectedException();
            }
            if (null != this.dataSocket || 0 != this.commandState) {
                throw new FtpBusyException();
            }
            this.flushOldResponses();
            this.sendCommand(string);
            this.commandState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int responseOnly(int n) throws FtpException {
        int n2 = -1;
        try {
            n2 = this.getAbortableResponse(n);
        }
        catch (FtpAbortedException ftpAbortedException) {
        }
        catch (FtpException ftpException) {
            try {
                this.sendCommand("abor");
                while (226 != this.getNonAbortableResponse(10000)) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.commandState = 0;
            throw ftpException;
        }
        Ftp ftp = this;
        synchronized (ftp) {
            if (2 == this.commandState) {
                Ftp ftp2 = this;
                synchronized (ftp2) {
                    this.commandState = 3;
                    this.notify();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                throw new FtpAbortedException();
            }
            this.commandState = 0;
        }
        return n2;
    }

    public int command(String string, int n) throws FtpException {
        this.logLine("Ftp sending command: " + string + " " + new Date().toString());
        this.commandOnly(string);
        this.logLine("Ftp in wait response ");
        int n2 = this.responseOnly(n);
        this.logLine("Ftp out wait response " + n2);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int connect(String string, String string2, String string3) throws FtpException {
        int n;
        if (null != this.commandSocket) {
            throw new FtpAlreadyConnectedException();
        }
        try {
            int n2;
            int n3;
            Serializable serializable;
            block19: {
                if (this.portUtility != null && this.portUtility.useCustomPort()) {
                    serializable = new ArrayList(10);
                    try {
                        while (true) {
                            try {
                                this.cmdPort = this.portUtility.getAvailablePort();
                                this.logLine("******************port: " + this.cmdPort);
                                this.commandSocket = new Socket();
                                this.commandSocket.setReuseAddress(true);
                                this.commandSocket.bind(new InetSocketAddress(this.cmdPort));
                                this.commandSocket.connect(new InetSocketAddress(string, 21));
                                break block19;
                            }
                            catch (BindException bindException) {
                                ((ArrayList)serializable).add(new Integer(this.cmdPort));
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        for (n3 = 0; n3 < ((ArrayList)serializable).size(); ++n3) {
                            n2 = (Integer)((ArrayList)serializable).get(n3);
                            this.portUtility.closePort(n2);
                        }
                    }
                }
                this.commandSocket = new Socket(string, 21);
            }
            serializable = this.commandSocket.getLocalAddress();
            this.logLine("******************localaddr: " + ((InetAddress)serializable).getHostAddress());
            n3 = this.commandSocket.getLocalPort();
            this.logLine("******************localPort: " + n3);
            n2 = this.commandSocket.getPort();
            this.logLine("******************hport: " + n2);
            InputStream inputStream = this.commandSocket.getInputStream();
            OutputStream outputStream = this.commandSocket.getOutputStream();
            this.commandInput = new BufferedReader(new InputStreamReader(inputStream));
            this.commandOutput = new BufferedWriter(new OutputStreamWriter(outputStream));
            n = this.getResponse(10000);
            if (n != 210) {
                this.commandSocket.close();
                this.commandSocket = null;
                this.commandInput = null;
                this.commandOutput = null;
                throw new FtpIOException(n);
            }
            this.commandState = 0;
        }
        catch (IOException iOException) {
            this.logLine("Exception in ftp connect ");
            if (this.debugWriter != null) {
                iOException.printStackTrace(this.debugWriter);
            }
            if (this.commandSocket != null) {
                try {
                    this.commandSocket.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                if (this.portUtility != null && this.portUtility.useCustomPort()) {
                    this.logLine("closePort " + this.cmdPort);
                    this.portUtility.closePort(this.cmdPort);
                }
            }
            this.commandSocket = null;
            this.commandInput = null;
            this.commandOutput = null;
            if (iOException instanceof UtilityOutOfPortsException) {
                throw new FtpOutOfPortsException();
            }
            throw new FtpIOException();
        }
        n = this.command("user " + string2, 10000);
        if (331 == n) {
            n = this.command("pass " + string3, 10000);
        }
        return n;
    }

    protected void port(int n) throws FtpException {
        byte[] byArray = this.commandSocket.getLocalAddress().getAddress();
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = byArray[i];
            if (nArray[i] >= 0) continue;
            int n2 = i;
            nArray[n2] = nArray[n2] + 256;
        }
        this.logLine("FTP port num " + n);
        this.logLine("FTP Create port " + "port " + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n / 256 + "," + n % 256 + " " + new Date().toString());
        int n3 = this.command("port " + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n / 256 + "," + n % 256, 10000);
        this.logLine("FTP Create port resp: " + n3 + " " + new Date().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int beginTransfer(String string) throws FtpException {
        ServerSocket serverSocket = null;
        if (null != this.dataSocket || 0 != this.commandState) {
            this.logLine("FtpBusyException beginTransfer " + new Date().toString());
            throw new FtpBusyException();
        }
        try {
            int n;
            serverSocket = this.trkServerSocket.createSocket();
            this.port(serverSocket.getLocalPort());
            this.logLine("FTP in commandOnly " + string + " using port: " + serverSocket.getLocalPort() + " " + new Date().toString());
            this.commandOnly(string);
            this.logLine("FTP out commandOnly " + string + " " + new Date().toString());
            try {
                serverSocket.setSoTimeout(10000);
                this.dataSocket = serverSocket.accept();
                this.dataSocket.setReceiveBufferSize(65536);
            }
            finally {
                n = this.responseOnly(10000);
            }
            this.logLine("FTP commandOnly response " + n + " " + new Date().toString());
            int n2 = n;
            return n2;
        }
        catch (IOException iOException) {
            if (iOException instanceof UtilityOutOfPortsException) {
                throw new FtpOutOfPortsException();
            }
            throw new FtpDataSocketException();
        }
        finally {
            if (null != this.trkServerSocket) {
                this.trkServerSocket.closeSocket();
            }
        }
    }

    protected void cleanDataSocket() {
        this.dataSocket = null;
        this.dataTextReader = null;
        this.dataTextWriter = null;
        this.dataInput = null;
        this.dataOutput = null;
        this.dataRawInput = null;
        this.dataRawOutput = null;
    }

    private int endTransfer() throws FtpException {
        return this.endTransfer(10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int endTransfer(int n) throws FtpException {
        int n2;
        Ftp ftp = this;
        synchronized (ftp) {
            if (null != this.dataSocket) {
                try {
                    this.dataSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        try {
            n2 = this.getAbortableResponse(n);
        }
        finally {
            ftp = this;
            synchronized (ftp) {
                if (null != this.dataSocket) {
                    this.cleanDataSocket();
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int abortTransfer() throws FtpException {
        int n;
        Ftp ftp = this;
        synchronized (ftp) {
            this.responseIsInterrupted = true;
        }
        try {
            this.sendCommand("abor");
            while (226 != (n = this.getNonAbortableResponse(10000))) {
            }
        }
        finally {
            ftp = this;
            synchronized (ftp) {
                this.responseIsInterrupted = false;
                if (null != this.dataSocket) {
                    try {
                        this.dataSocket.close();
                    }
                    catch (IOException iOException) {}
                    this.cleanDataSocket();
                }
            }
        }
        return n;
    }

    private void transferPrologue() throws FtpException {
        if (this.dataTransferInProgress) {
            throw new FtpBusyException();
        }
        this.dataTransferInProgress = true;
    }

    private void transferEpilogue() {
        this.dataTransferInProgress = false;
    }

    public synchronized int sendStart(String string) throws FtpException {
        this.logLine("FTP in sendStart beginTransfer: " + new Date().toString());
        int n = this.beginTransfer("stor " + string);
        this.logLine("FTP out sendStart beginTransfer: " + n + " " + new Date().toString());
        try {
            if (150 == n) {
                this.dataRawOutput = this.dataSocket.getOutputStream();
                this.dataTextWriter = new PrintWriter((Writer)new OutputStreamWriter(this.dataRawOutput), true);
                this.dataOutput = this.isLittleEndianData ? new LittleEndianOutputStream(this.dataRawOutput) : new DataOutputStream(this.dataRawOutput);
            }
            return n;
        }
        catch (IOException iOException) {
            this.logLine("FTP in sendStart IOException: " + new Date().toString());
            throw new FtpDataSocketException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLine(String string) throws FtpException {
        PrintWriter printWriter;
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataTextWriter) {
                throw new FtpDataSocketException();
            }
            this.transferPrologue();
            printWriter = this.dataTextWriter;
        }
        try {
            printWriter.println(string);
        }
        finally {
            ftp = this;
            synchronized (ftp) {
                this.transferEpilogue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBuffer(byte[] byArray) throws FtpException {
        OutputStream outputStream;
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataRawOutput) {
                throw new FtpDataSocketException();
            }
            this.transferPrologue();
            outputStream = this.dataRawOutput;
        }
        try {
            outputStream.write(byArray);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new FtpNoResponseException();
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
        finally {
            Ftp ftp2 = this;
            synchronized (ftp2) {
                this.transferEpilogue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendByte(byte by) throws FtpException {
        DataOutput dataOutput;
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataOutput) {
                throw new FtpDataSocketException();
            }
            this.transferPrologue();
            dataOutput = this.dataOutput;
        }
        try {
            dataOutput.write(by);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new FtpNoResponseException();
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
        finally {
            Ftp ftp2 = this;
            synchronized (ftp2) {
                this.transferEpilogue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUnsignedShort(int n) throws FtpException {
        DataOutput dataOutput;
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataOutput) {
                throw new FtpDataSocketException();
            }
            this.transferPrologue();
            dataOutput = this.dataOutput;
        }
        try {
            dataOutput.writeShort((short)n);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new FtpNoResponseException();
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
        finally {
            Ftp ftp2 = this;
            synchronized (ftp2) {
                this.transferEpilogue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUnsignedInt(long l) throws FtpException {
        DataOutput dataOutput;
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataOutput) {
                throw new FtpDataSocketException();
            }
            this.transferPrologue();
            dataOutput = this.dataOutput;
        }
        try {
            dataOutput.writeInt((int)l);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new FtpNoResponseException();
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
        finally {
            Ftp ftp2 = this;
            synchronized (ftp2) {
                this.transferEpilogue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDouble(double d) throws FtpException {
        DataOutput dataOutput;
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataOutput) {
                throw new FtpDataSocketException();
            }
            this.transferPrologue();
            dataOutput = this.dataOutput;
        }
        try {
            dataOutput.writeDouble(d);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new FtpNoResponseException();
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
        finally {
            Ftp ftp2 = this;
            synchronized (ftp2) {
                this.transferEpilogue();
            }
        }
    }

    public int sendEnd() throws FtpException {
        return this.sendEnd(1800000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendEnd(int n) throws FtpException {
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataRawOutput) {
                throw new FtpDataSocketException();
            }
        }
        return this.endTransfer(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendAbort() throws FtpException {
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataRawOutput) {
                throw new FtpDataSocketException();
            }
        }
        return this.abortTransfer();
    }

    public synchronized int receiveStart(String string) throws FtpException {
        this.logLine("FTP in receiveStart beginTransfer: " + new Date().toString());
        int n = this.beginTransfer("retr " + string);
        this.logLine("FTP out receiveStart beginTransfer: " + n + " " + new Date().toString());
        try {
            if (150 == n) {
                this.dataSocket.setSoTimeout(0);
                this.dataRawInput = this.dataSocket.getInputStream();
                this.dataTextReader = new BufferedReader(new InputStreamReader(this.dataRawInput));
                this.dataInput = this.isLittleEndianData ? new LittleEndianInputStream(this.dataRawInput) : new DataInputStream(this.dataRawInput);
            }
            return n;
        }
        catch (IOException iOException) {
            this.logLine("FTP in receiveStart IOException: " + new Date().toString());
            throw new FtpDataSocketException();
        }
    }

    public synchronized int receiveBytesAvailable() throws FtpException {
        try {
            return this.dataRawInput.available();
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
        catch (NullPointerException nullPointerException) {
            throw new FtpDataSocketException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String receiveLine() throws FtpException {
        String string;
        BufferedReader bufferedReader;
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataTextReader) {
                throw new FtpDataSocketException();
            }
            this.transferPrologue();
            bufferedReader = this.dataTextReader;
        }
        try {
            string = bufferedReader.readLine();
        }
        catch (EOFException eOFException) {
            throw new FtpNoResponseException();
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
        finally {
            Ftp ftp2 = this;
            synchronized (ftp2) {
                this.transferEpilogue();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveBuffer(byte[] byArray) throws FtpException {
        int n;
        InputStream inputStream;
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataRawInput) {
                throw new FtpDataSocketException();
            }
            this.transferPrologue();
            inputStream = this.dataRawInput;
        }
        try {
            n = inputStream.read(byArray);
        }
        catch (EOFException eOFException) {
            throw new FtpNoResponseException();
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
        finally {
            Ftp ftp2 = this;
            synchronized (ftp2) {
                this.transferEpilogue();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte receiveByte() throws FtpException {
        byte by;
        DataInput dataInput;
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataInput) {
                throw new FtpDataSocketException();
            }
            this.transferPrologue();
            dataInput = this.dataInput;
        }
        try {
            by = dataInput.readByte();
        }
        catch (EOFException eOFException) {
            throw new FtpNoResponseException();
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
        finally {
            Ftp ftp2 = this;
            synchronized (ftp2) {
                this.transferEpilogue();
            }
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveUnsignedShort() throws FtpException {
        int n;
        DataInput dataInput;
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataInput) {
                throw new FtpDataSocketException();
            }
            this.transferPrologue();
            dataInput = this.dataInput;
        }
        try {
            n = dataInput.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            throw new FtpNoResponseException();
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
        finally {
            Ftp ftp2 = this;
            synchronized (ftp2) {
                this.transferEpilogue();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long receiveUnsignedInt() throws FtpException {
        long l;
        DataInput dataInput;
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataInput) {
                throw new FtpDataSocketException();
            }
            this.transferPrologue();
            dataInput = this.dataInput;
        }
        try {
            l = (long)dataInput.readInt() & 0xFFFFFFFFL;
        }
        catch (EOFException eOFException) {
            throw new FtpNoResponseException();
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
        finally {
            Ftp ftp2 = this;
            synchronized (ftp2) {
                this.transferEpilogue();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double receiveDouble() throws FtpException {
        double d;
        DataInput dataInput;
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataInput) {
                throw new FtpDataSocketException();
            }
            this.transferPrologue();
            dataInput = this.dataInput;
        }
        try {
            d = dataInput.readDouble();
        }
        catch (EOFException eOFException) {
            throw new FtpNoResponseException();
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
        finally {
            Ftp ftp2 = this;
            synchronized (ftp2) {
                this.transferEpilogue();
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveSkip(int n) throws FtpException {
        InputStream inputStream;
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataRawInput) {
                throw new FtpDataSocketException();
            }
            this.transferPrologue();
            inputStream = this.dataRawInput;
        }
        try {
            inputStream.skip(n);
        }
        catch (EOFException eOFException) {
            throw new FtpNoResponseException();
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
        finally {
            Ftp ftp2 = this;
            synchronized (ftp2) {
                this.transferEpilogue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveEnd() throws FtpException {
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataRawInput) {
                throw new FtpDataSocketException();
            }
        }
        return this.endTransfer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveAbort() throws FtpException {
        Ftp ftp = this;
        synchronized (ftp) {
            if (null == this.dataRawInput) {
                throw new FtpDataSocketException();
            }
        }
        return this.abortTransfer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cmdAbort() throws FtpException {
        Ftp ftp = this;
        synchronized (ftp) {
            switch (this.commandState) {
                case 1: {
                    this.responseIsInterrupted = true;
                    this.commandState = 2;
                    break;
                }
                case 0: {
                    this.commandState = 5;
                    return 226;
                }
                default: {
                    throw new FtpBusyException();
                }
            }
        }
        try {
            int n;
            ftp = this;
            synchronized (ftp) {
                while (3 != this.commandState) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.responseIsInterrupted = false;
            this.sendCommand("abor");
            this.commandSocket.setSoTimeout(10000);
            while (226 != (n = this.getNonAbortableResponse(10000))) {
            }
            int n2 = n;
            return n2;
        }
        catch (IOException iOException) {
            throw new FtpIOException();
        }
        finally {
            Ftp ftp2 = this;
            synchronized (ftp2) {
                this.commandState = 5;
                this.notify();
            }
        }
    }

    public int abort() throws FtpException {
        int n;
        try {
            n = this.cmdAbort();
        }
        finally {
            this.commandState = 0;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() throws FtpException {
        this.logLine("Ftp Disconnect");
        if (null == this.commandSocket) {
            throw new FtpNotConnectedException();
        }
        try {
            this.cmdAbort();
            Ftp ftp = this;
            synchronized (ftp) {
                if (null != this.dataSocket) {
                    try {
                        this.dataSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.cleanDataSocket();
                }
            }
            this.sendCommand("quit");
            while (221 != this.getNonAbortableResponse(4000)) {
            }
        }
        finally {
            this.logLine("close commandSocket ");
            try {
                this.commandSocket.close();
            }
            catch (IOException iOException) {}
            try {
                this.commandInput.close();
            }
            catch (IOException iOException) {}
            try {
                this.commandOutput.close();
            }
            catch (IOException iOException) {}
            this.commandSocket = null;
            this.commandInput = null;
            this.commandOutput = null;
            if (this.portUtility != null && this.portUtility.useCustomPort()) {
                this.logLine("closePort " + this.cmdPort);
                this.portUtility.closePort(this.cmdPort);
            }
        }
    }

    public synchronized InetAddress getIPAddress() throws FtpException {
        if (null == this.commandSocket) {
            throw new FtpNotConnectedException();
        }
        return this.commandSocket.getLocalAddress();
    }

    public synchronized InetAddress getRemoteIPAddress() throws FtpException {
        if (null == this.commandSocket) {
            throw new FtpNotConnectedException();
        }
        return this.commandSocket.getInetAddress();
    }

    protected void logLine(String string) {
        if (this.debugWriter != null) {
            this.debugWriter.println(string);
        }
    }
}

